	MCOPY	MACROS
	COPY	2:AINCLUDE:E16.FOUNDATION
	COPY	PSTRING.EQU
	COPY	REMHEADER.ASM

*========================================================================
* REM_OPEN initiates an editing session (or a selector session) and is the
* first resource specific call made to the editor.
*
* The editor must support four types of open, five if it has a selector.
*
* A new item needs to be created from scratch.
*	fFlag bits 8 (F_OPENSILENT) and 9 (F_OPENDATA) are clear.
*	The resID is NIL so the editor must assign the resource's new ID.
*	The resource does not exist in the workfile and must be added.
*	The editor MUST open an editing window.
*	The editor can provide default data for the new item.
*
* A new item needs to be created with default data provided by another source.
* The data is provided in a handle, and the new item may
*	fFlag bit 8 is clear.
*	fFlag bit 9 is set and default data for the new item is provided.
*	The resID MIGHT be pre-assigned.
*	The resource does not exist in the workfile and must be added.
*	The editor MUST open an editing window.
*
* A new item needs to be created, but the REM should simply make it and return.
*	fFlag bit 8 is set.
*	fFlag bit 9 MAY BE set with default data for the new item provided.
*	The resID MIGHT be pre-assigned.
*	The resource does not exist in the workfile and must be added.
*	The editor MUST NOT open an editing window.
*
* An existing resource needs to be edited.  This is the most common case.
*	fFlag bits 8 and 9 are clear.
*	The resID is a valid ID
*	the resource to be edited exists in the workfile.
*	The editor MUST open an editing window.
*
* The REM supports a resource selector (this sample doesn't have a selector)
*	fFlag bits 9 and 10 (F_REMSELECT) will be set.
*	The list member record array that the shell would normally have used in
*	the standard type window's item list is the provided data.
*	The editor MUST open a selector window.
*
* The REM_OPEN parameter block looks like this:
*
* fOpenRec
*   word		resType      - must be rPString for this example editor
*   long		resID        - 0x00000000 ... 0x07ffffff
*   word		fFlag        - 0x0200 Data Valid, 0x0100 Silent, 0x0300 B0oth
*   Handle	Data         - If Data Valid, this is a pstring handle
*   Pointer	wColorPtr    - The color table for the active workfile
*
REM_OPEN START
*
* word REM_OPEN(fOpenRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_OPEN'
go	CSUB	(4:p),30
*
result	EQU	dp	01 word
localPtr1 EQU	dp+2	03 Pointer
*
ctlH	EQU	dp+6	07 Handle
private	EQU	dp+10	0B privateDataHndl
winP	EQU	dp+14	0F GrafPortPtr
tempH	EQU	dp+18	13 ParamListHndl

localPtr3 EQU	dp+22	17 Pointer
localPtr2 EQU	dp+26	1B Pointer
*
* First see if we edit this type...
* (a multi-type editor will have to case those types it supports)
*
	LDA	[p]	if (p->resType != rPString)
	CMP	#rPString
	BEQ	endif1

	LDA	#resInvalidTypeOrID	return resInvalidTypeOrID
	STA	result
	BRL	return
*
* Now handle a "new resource" check.  First we will see if there
* is data provided and either load it or the editor's built-in
* default (ID 1).  Then we add the resource, posibly getting a new
* ID in the process.  Last, if the request was silent, we're done
* and hould just release the resource because something else needs
* needs it.
*
* if (!p->resID || (p->fFlag & (F_OPENSILENT | F_OPENDATA)))
*
endif1	LDY	#oOpen_resID	p->resID
	LDA	[p],Y
	INY
	INY
	ORA	[p],Y
	BEQ	doif2

	LDY	#oOpen_fFlag	p->fFlag
	LDA	[p],Y
	AND	#F_OPENSILENT+F_OPENDATA
	BNE	doif2
	BRL	endif2

doif2	LDA	#rPString
	STA	DataPB+oResData_resType	DataPB.resType = rPString
	STA	RefPB+oResRef_resType	RefPB.resType = rPString
*
* data is provided - handle is ours
*
	LDY	#oOpen_fFlag	if (p->fFlag & F_OPENDATA)
	LDA	[p],Y
	AND	#F_OPENDATA
	BEQ	else3

	LDY	#oOpen_Data	DataPB.resData = p->Data;
	LDA	[p],Y
	STA	DataPB+oResData_resData
	INY
	INY
	LDA	[p],Y
	STA	DataPB+oResData_resData+2
	BRA	endif3
*
* no data, load default from editor
*
else3	LDA	#6	DataPB.pCount = 6
	STA	DataPB+oResData_pCount
*
* the default resource's ID
*
	LDA	#1	DataPB.resID = 1L
	STA	DataPB+oResData_resID
	STZ	DataPB+oResData_resID+2

	LDA	edResFileID	DataPB.resFileID = edResFileID
	STA	DataPB+oResData_resFileID
*
* we want this one here
*
	_fLoadResource DataPB	(void)fLoadResource(& DataPB)
*
* detach default so we own it
*
	LDA	#3	RefPB.pCount = 3
	STA	RefPB+oResRef_pCount

	LDA	#1	RefPB.resID = 1L
	STA	RefPB+oResRef_resID
	STZ	RefPB+oResRef_resID+2

	LDA	edResFileID	RefPB.resFileID = edResFileID
	STA	RefPB+oResRef_resFileID

	_fDetachResource RefPB	(void)fDetachResource(& RefPB)

endif3	LDA	#4	DataPB.pCount = 4
	STA	DataPB+oResData_pCount
*
* if null, then Add returns ID added
*
	LDY	#oOpen_resID	DataPB.resID = p->resID
	LDA	[p],Y
	STA	DataPB+oResData_resID
	INY
	INY
	LDA	[p],Y
	STA	DataPB+oResData_resID+2
*
* no attributes assigned
*
	STZ	DataPB+oResData_special	DataPB.special = 0

	_fAddResource DataPB	(void)fAddResource(& DataPB)
*
* this may change so pass it back
*
	LDY	#oOpen_resID	p->resID = DataPB.resID
	LDA	DataPB+oResData_resID
	STA	[p],Y
	INY
	INY
	LDA	DataPB+oResData_resID+2
	STA	[p],Y

	LDA	#2	RefPB.pCount = 2
	STA	RefPB+oResRef_pCount

	LDA	DataPB+oResData_resID	RefPB.resID = DataPB.resID
	STA	RefPB+oResRef_resID
	LDA	DataPB+oResData_resID+2
	STA	RefPB+oResRef_resID+2

	_fReleaseResource RefPB	(void)fReleaseResource(& RefPB)
*
* this was a silent request - done!
*
	LDY	#oOpen_fFlag	if (p->fFlag & F_OPENSILENT)
	LDA	[p],Y
	AND	#F_OPENSILENT
	BEQ	endif2

	STZ	result	return 0
	BRL	return
*
* If we get here, we definitely have a valid resource to edit in the
* workfile, and we move into "normal open" mode:
*	Load the editor's window converted to a handle reference
*	Get the official window title from the shell
*	Open the editor's window (hidden for appearance only)
*	Set the window's private data interface structure in the shell
*	Load the resource we're to edit
*	Assign the resource and title handles in our private data handle
*
* (Handle)private = NewHandle(8L, fUserID, 0x0018, 0L);
*
endif2	PHA
	PHA
	PEA	8|-16
	PEA	8
	LDA	fUserID
	PHA
	PEA	$18
	PEA	0|-16
	PEA	0
	_NewHandle
	PLA
	STA	private
	PLA
	STA	private+2
*
* get and lock our window stuff
*
	LDA	#5	DataPB.pCount = 5
	STA	DataPB+oResData_pCount

	LDA	#rWindParam1	DataPB.resType = rWindParam1
	STA	DataPB+oResData_resType

	LDA	#1	DataPB.resID = 0x00000001L
	STA	DataPB+oResData_resID
	STZ	DataPB+oResData_resID+2

	STZ	DataPB+oResData_special	DataPB.special = 0	load

	LDA	edResFileID	DataPB.resFileID = edResFileID
	STA	DataPB+oResData_resFileID

	_fSpecialMagic DataPB	(void)fSpecialMagic(& DataPB)

	LDA	#1	DataPB.special = 1	lock
	STA	DataPB+oResData_special

	_fSpecialMagic DataPB	(void)fSpecialMagic(& DataPB)

	LDA	DataPB+oResData_resData	tempH = (ParamListHndl)DataPB.resData
	STA	tempH
	LDA	DataPB+oResData_resData+2
	STA	tempH+2
*
* (**private).ctlH = (CtlRecHndl)(**tempH).wStorage;
*
	LDY	#2	(**private)
	LDA	[private]
	STA	localPtr2
	LDA	[private],Y
	STA	localPtr2+2

	LDA	[tempH]	(**tempH)
	STA	localPtr1
	LDA	[tempH],Y
	STA	localPtr1+2

	LDY	#owStorage	.wStorage
	LDA	[localPtr1],Y
	TAX
	INY
	INY
	LDA	[localPtr1],Y

	LDY	#oprivate_ctlH+2	.ctlH
	STA	[localPtr2],Y
	DEY
	DEY
	TXA
	STA	[localPtr2],Y
*
* winP = NewWindow2((Pointer)0, 0L, & DrawProc, (LongProcPtr)0, 1, (Ref)DataPB.resData, rWindParam1);
*
	PHA
	PHA
	LDA	#0	PEA's use more space and are slower
	PHA
	PHA
	PHA
	PHA
	PEA	DrawProc|-16
	PEA	DrawProc
	PHA
	PHA
	PEA	1
	LDA	DataPB+oResData_resData+2
	PHA
	LDA	DataPB+oResData_resData
	PHA
	PEA	rWindParam1
	_NewWindow2
	PLA
	STA	winP
	PLA
	STA	winP+2
*
* SetWTitle((Ref)getTitle(rPString, p->resID), winP);
*
	LDY	#oOpen_resID
	LDA	[p],Y
	STA	localPtr3
	INY
	INY
	LDA	[p],Y
	STA	localPtr3+2

	PEI	localPtr3+2
	PEI	localPtr3
	PEA	rPString
	JSL	getTitle
	PHX
	PHA
	PEI	winP+2
	PEI	winP
	_SetWTitle

	PEI	winP+2	SetPort(winP)
	PEI	winP
	_SetPort
*
* setup the window refCon for the shell
*
	LDA	#7	PrivPB.pCount = 7
	STA	PrivPB+oPrivateData_pCount

	LDA	winP	(GrafPortPtr)PrivPB.winPtr = winP
	STA	PrivPB+oPrivateData_winPtr
	LDA	winP+2
	STA	PrivPB+oPrivateData_winPtr+2
*
* use standard task mask
*
	STZ	PrivPB+oPrivateData_remTaskMask	PrivPB.remTaskMask = 0L
	STZ	PrivPB+oPrivateData_remTaskMask+2
*
* personal signature - no significance
*
	STZ	PrivPB+oPrivateData_remSignature	PrivPB.remSignature = 0

	LDA	private	PrivPB.Data = (Handle)private
	STA	PrivPB+oPrivateData_Data
	LDA	private+2
	STA	PrivPB+oPrivateData_Data+2

	LDA	#$20	PrivPB.groupSignature = 0x0020
	STA	PrivPB+oPrivateData_groupSignature

	LDA	#rPString	PrivPB.resType = rPString
	STA	PrivPB+oPrivateData_resType

	LDA	localPtr3	PrivPB.resID = p->resID
	STA	PrivPB+oPrivateData_resID
	LDA	localPtr3+2
	STA	PrivPB+oPrivateData_resID+2

	_fAddPrivateData PrivPB	fAddPrivateData(& PrivPB)
*
* finally, get the resource we're editing
*
	LDA	#3	DataPB.pCount = 3
	STA	DataPB+oResData_pCount

	LDA	#rPString	DataPB.resType = rPString
	STA	DataPB+oResData_resType

	LDA	localPtr3	DataPB.resID = p->resID
	STA	DataPB+oResData_resID
	LDA	localPtr3+2
	STA	DataPB+oResData_resID+2

	_fLoadResource DataPB	(void)fLoadResource(& DataPB)

	LDY	#2	(**private).data = DataPB.resData
	LDA	DataPB+oResData_resData
	STA	[localPtr2]
	LDA	DataPB+oResData_resData+2
	STA	[localPtr2],Y
*
*  Now we set the data into the TE control, set the window colors,
*  and show the window, completing the REM_OPEN call.
*
* ctlH = (Handle)GetCtlHandleFromID((WindowPtr)winP, 1L);
*
	PHA
	PHA
	PEI	winP+2
	PEI	winP
	PEA	1|-16
	PEA	1
	_GetCtlHandleFromID
	PLA
	STA	ctlH
	PLA
	STA	ctlH+2
*
* TESetText(teTextIsHandle + teDataIsPString, (Ref)DataPB.resData, 0L, 0, (Ref)0, ctlH);
*
	PEA	8
	LDA	DataPB+oResData_resData+2
	PHA
	LDA	DataPB+oResData_resData
	PHA
	LDA	#0
	PHA
	PHA
	PHA
	PHA
	PHA
	PEI	ctlH+2
	PEI	ctlH
	_TESetText
*
* SetFrameColor((WindColorPtr)p->wColorPtr, winP);
*
	LDY	#oOpen_wColorPtr+2	p->wColorPtr
	LDA	[p],Y
	PHA
	DEY
	DEY
	LDA	[p],Y
	PHA
	PEI	winP+2
	PEI	winP
	_SetFrameColor

	PEI	winP+2	ShowWindow(winP)
	PEI	winP
	_ShowWindow

	STZ	result	return 0

return	RET	2:result
	RTL
	END

*========================================================================
* REM_CLOSE updates the resource if it has changed, and closes up shop.
*
* The REM_CLOSE parameter block looks like this:
*
* fCloseRec
*   word		resType     - rPString
*   long		resID       - 0x00000001 ... 0x07ffffff
*   word		fFlag       - no input
*   Pointer	windowPtr   - editor's GrafPortPtr
*
REM_CLOSE START
*
*word REM_CLOSE(fCloseRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_CLOSE'
go	CSUB	(4:p),26
*
result	EQU	dp	01 word
localPtr2 EQU	dp+2	03 Pointer
localPtr1 EQU	dp+6	07 Pointer
*
txtData	EQU	dp+10	0A handle
txtLength EQU	dp+14	0F long
winP	EQU	dp+18	13 GrafPortPtr
private	EQU	dp+22	17 privateDataHndl
*
	LDY	#oClose_windowPtr	winP = (GrafPortPtr)p->windowPtr
	LDA	[p],Y
	STA	winP
	INY
	INY
	LDA	[p],Y
	STA	winP+2
*
* txtLength = TEGetText(0x0018, (Ref)& txtData, 0L, 0, (Ref)0, (Handle)GetCtlHandleFromID(winP, 1L));
*
	PHA
	PHA
	PEA	$18
	TDC
	CLC
	ADC	#txtData
	LDX	#0
	PHX
	PHA
	PHX
	PHX
	PHX
	PHX
	PHX
	PHA
	PHA
	PEI	winP+2
	PEI	winP
	PEA	1|-16
	PEA	1
	_GetCtlHandleFromID
	_TEGetText
	PLA
	STA	txtLength
	PLA
	STA	txtLength+2

	PEI	winP+2	private = getPrivate(winP)
	PEI	winP
	JSL	getPrivate
	STX	private+2
	STA	private
*
* checkData(p->resID, (**private).data, txtData);
*
	LDY	#oClose_resID
	LDA	[p],Y
	STA	localPtr1
	INY
	INY
	LDA	[p],Y
	STA	localPtr1+2

	PEI	txtData+2
	PEI	txtData

	LDY	#2	deref private
	LDA	[private]
	STA	localPtr2
	LDA	[private],Y
	STA	localPtr2+2

	LDA	[localPtr2],Y
	PHA
	LDA	[localPtr2]
	PHA
	PEI	localPtr1+2
	PEI	localPtr1
	JSL	checkData

	PEI	winP+2	DisposeHandle((Handle)getPrivate(winP))
	PEI	winP
	JSL	getPrivate
	PHX
	PHA
	_DisposeHandle

	LDA	#1	PrivPB.pCount = 1;
	STA	PrivPB+oPrivateData_pCount

	LDA	winP	PrivPB.winPtr = (pointer)winP
	STA	PrivPB+oPrivateData_winPtr
	LDA	winP+2
	STA	PrivPB+oPrivateData_winPtr+2

	_fRelPrivateData PrivPB	fRelPrivateData(& PrivPB)

	PEI	winP+2	CloseWindow(winP)
	PEI	winP
	_CloseWindow

	LDA	#2	RefPB.pCount = 2
	STA	RefPB

	LDA	localPtr1	RefPB.resID = p->resID
	STA	RefPB+oResRef_resID
	LDA	localPtr1+2
	STA	RefPB+oResRef_resID+2

	_fReleaseResource RefPB	(void)fReleaseResource(& RefPB)

	STZ	result	return 0
	RET	2:result
	END

*========================================================================
* REM_WRITE updates the resource if it has changed.
*
* The REM_CLOSE parameter block is used by REM_WRITE too:
*
* fCloseRec
*   word		resType     - rPString
*   long		resID       - 0x00000001 ... 0x07ffffff
*   word		fFlag       - no input
*   Pointer	windowPtr   - editor's GrafPortPtr
*
REM_WRITE START
*
*word REM_WRITE(fCloseRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_WRITE'
go	CSUB	(4:p),22
*
result	EQU	dp	01 word
localPtr	EQU	dp+2	03 Pointer
*
txtData	EQU	dp+6	07 handle
txtLength EQU	dp+10	0B long
winP	EQU	dp+14	0F GrafPortPtr
private	EQU	dp+18	13 privateDataHndl
*
	LDY	#oClose_windowPtr	winP = (GrafPortPtr)p->windowPtr
	LDA	[p],Y
	STA	winP
	INY
	INY
	LDA	[p],Y
	STA	winP+2
*
* txtLength = TEGetText(0x0018, (Ref)& txtData, 0L, 0, (Ref)0, (Handle)GetCtlHandleFromID(winP, 1L));
*
	PHA
	PHA
	PEA	$18
	TDC
	CLC
	ADC	#txtData
	LDX	#0
	PHX
	PHA
	PHX
	PHX
	PHX
	PHX
	PHX
	PHA
	PHA
	PEI	winP+2
	PEI	winP
	PEA	1|-16
	PEA	1
	_GetCtlHandleFromID
	_TEGetText
	PLA
	STA	txtLength
	PLA
	STA	txtLength+2

	PEI	winP+2	private = getPrivate(winP)
	PEI	winP
	JSL	getPrivate
	STX	private+2
	STA	private
*
* checkData(p->resID, (**private).data, txtData);
*
	PEI	txtData+2
	PEI	txtData

	LDY	#2	deref private
	LDA	[private]
	STA	localPtr
	LDA	[private],Y
	STA	localPtr+2

	LDA	[localPtr],Y
	PHA
	LDA	[localPtr]
	PHA

	LDY	#oClose_resID+2	p->resID
	LDA	[p],Y
	PHA
	DEY
	DEY
	LDA	[p],Y
	PHA
	JSL	checkData

	STZ	result	return 0
	RET	2:result
	END

*========================================================================
*
REM_EVENT START
*
* word REM_EVENT(fEventRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_EVENT'
go	CSUB	(4:p),10

result	EQU	dp	01 word
localPtr	EQU	dp+2	03 Pointer

winP	EQU	dp+6	07 GrafPortPtr

	LDA	fEventPtr	winP =(GrafPortPtr)fEventPtr->wmTaskData
	STA	localPtr
	LDA	fEventPtr+2
	STA	localPtr+2

	LDY	#owmTaskData	fEventPtr->wmTaskData
	LDA	[localPtr],Y
	STA	winP
	INY
	INY
	LDA	[localPtr],Y
	STA	winP+2

	LDY	#oEvent_taskCode	if (p->taskCode)
	LDA	[p],Y
	CMP	#app3Evt
	BNE	endif
*
*   SetWTitle((Ref)getTitle(rPString, p->resID), winP);
*
doEvent	LDY	#oEvent_resID+2	p->resID
	LDA	[p],Y
	PHA
	DEY
	DEY
	LDA	[p],Y
	PHA
	PEA	rPString
	JSL	getTitle
	PHX
	PHA
	PEI	winP+2
	PEI	winP
	_SetWTitle

endif	STZ	result	return 0
	RET	2:result
	END

*========================================================================
*
REM_ACTIVATE START
*
* word REM_ACTIVATE(fActivateRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_ACTIVATE'
go	CSUB	(4:p),26
*
result	EQU	dp	01 word
localPtr2 EQU	dp+2	03 Pointer
*
txtData	EQU	dp+6	07 handle
winP	EQU	dp+10	0B GrafPortPtr
txtLength EQU	dp+14	0F long
private	EQU	dp+18	13 privateDataHndl
*
localPtr1 EQU	dp+22	17 Pointer
*
	LDY	#oActivate_fFlag	if (p->fFlag & F_ACTIVATE)
	LDA	[p],Y
	AND	#F_ACTIVATE
	BEQ	else
*
*  p->fFlag |= (F_CLIP + F_CLEAR + F_MENUAPPLY);
*
	LDA	p
	LDX	p+2
	CLC
	ADC	#oActivate_fFlag
	BCC	HighOk
	INX
HighOk	STA	localPtr1
	STX	localPtr1+2

	LDA	[localPtr1]
	ORA	#F_CLIP+F_CLEAR+F_MENUAPPLY
	STA	[localPtr1]
	BRL	endif
*
*  winP = (GrafPortPtr)fEventPtr->wmTaskData;
*
else	LDA	fEventPtr
	STA	localPtr2
	LDA	fEventPtr+2
	STA	localPtr2+2

	LDY	#owmTaskData	fEventPtr->wmTaskData
	LDA	[localPtr2],Y
	STA	winP
	INY
	INY
	LDA	[localPtr2],Y
	STA	winP+2
*
*  txtLength = TEGetText(0x0018, (Ref)& txtData, 0L, 0, (Ref)0, (Handle)GetCtlHandleFromID(winP, 1L));
*
	PHA
	PHA
	PEA	$18
	TDC
	CLC
	ADC	#txtData
	LDX	#0
	PHX
	PHA
	PHX
	PHX
	PHX
	PHX
	PHX
	PHA
	PHA
	PEI	winP+2
	PEI	winP
	PEA	1|-16
	PEA	1
	_GetCtlHandleFromID
	_TEGetText
	PLA
	STA	txtLength
	PLA
	STA	txtLength+2

	PEI	winP+2	private = getPrivate(winP)
	PEI	winP
	JSL	getPrivate
	STX	private+2
	STA	private
*
*  checkData(p->resID, (**private).data, txtData);
*
	PEI	txtData+2
	PEI	txtData

	LDY	#2
	LDA	[private]
	STA	localPtr2
	LDA	[private],Y
	STA	localPtr2+2

	LDA	[localPtr2],Y
	PHA
	LDA	[localPtr2]
	PHA

	LDY	#oActivate_resID+2	p->resID
	LDA	[p],Y
	PHA
	DEY
	DEY
	LDA	[p],Y
	PHA
	JSL	checkData

endif	STZ	result	return 0
	RET	2:result
	END

*========================================================================
* REM_GETLINK is an extension to the shell's dependency structure.  Pascal
* Strings don't have dependents.  The supports REM_GETLINK rFlag bit 6 in
* the remStartRes is clear.
*
REM_GETLINK START
*
* word REM_GETLINK(fLinkRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_GETLINK'
go	CSUB	(4:p),2
*
result	EQU	dp	word

	STZ	result	return 0
	RET	2:result
	END

*========================================================================
* REM_VIDMODE lets the editor know when it's world is changing.  We didn't
* see a valid reason for a 320 mode Pascal String editor, but decided to
* support one anyway.
*
REM_VIDMODE START
*
* word REM_VIDMODE(fVidModeRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_VIDMODE'
go	CSUB	(4:p),34
*
result	EQU	dp	01 word
localPtr	EQU	dp+2	03 Pointer
*
winP	EQU	dp+6	07 GrafPortPtr
locWinP	EQU	dp+10	0B Pointer
ctlH	EQU	dp+14	0F Handle
txtLength EQU	dp+18	13 long
winH	EQU	dp+22	17 ParamListHndl
txtData	EQU	dp+26	1B handle
private	EQU	dp+30	1F privateDataHndl

	LDY	#oVidMode_windowPtr	(pointer)winP = p->windowPtr
	LDA	[p],Y
	STA	winP
	STA	locWinP
	INY
	INY
	LDA	[p],Y
	STA	winP+2
	STA	locWinP+2

	PEI	locWinP+2	private = getPrivate(winP)
	PEI	locWinP
	JSL	getPrivate
	STX	private+2
	STA	private
*
* ctlH = (handle)GetCtlHandleFromID(winP, 1L);
*
	PHA
	PHA
	PEI	locWinP+2
	PEI	locWinP
	PEA	1|-16
	PEA	1
	_GetCtlHandleFromID
	PLA
	STA	ctlH
	PLA
	STA	ctlH+2
*
* txtLength = TEGetText(0x0018, (Ref)& txtData, 0L, 0, 0L, ctlH);
*
	PHA
	PHA
	PEA	$18
	TDC
	CLC
	ADC	#txtData
	LDX	#0
	PHX
	PHA
	PHX
	PHX
	PHX
	PHX
	PHX
	PEI	ctlH+2
	PEI	ctlH
	_TEGetText
	PLA
	STA	txtLength
	PLA
	STA	txtLength+2

	PEI	ctlH+2	HideControl((CtlRecHndl)ctlH)
	PEI	ctlH
	_HideControl

	PEI	ctlH+2	DisposeControl((CtlRecHndl)ctlH)
	PEI	ctlH
	_DisposeControl
*
* (CtlRecHndl)ctlH = NewControl2(winP, 1, (Ref)(**private).ctlH);
*
	PHA
	PHA
	PEI	locWinP+2
	PEI	locWinP
	PEA	1
	LDY	#2
	LDA	[private]
	STA	localPtr
	LDA	[private],Y
	STA	localPtr+2
	LDY	#oprivate_ctlH+2
	LDA	[localPtr],Y
	PHA
	DEY
	DEY
	LDA	[localPtr],Y
	PHA
	_NewControl2
	PLA
	STA	ctlH
	PLA
	STA	ctlH+2
*
* TESetText(teTextIsHandle + teDataIsPString, (Ref)txtData, 0L, 0, 0L, ctlH);
*
	PEA	8
	PEI	txtData+2
	PEI	txtData
	LDA	#0
	PHA
	PHA
	PHA
	PHA
	PHA
	PEI	ctlH+2
	PEI	ctlH
	_TESetText
*
* SetFrameColor((WindColorPtr)p->wColorPtr, (GrafPortPtr)p->windowPtr);
*
	LDY	#oVidMode_wColorPtr+2	p->windowPtr
	LDA	[p],Y
	PHA
	DEY
	DEY
	LDA	[p],Y
	PHA
	PEI	winP+2
	PEI	winP
	_SetFrameColor

	STZ	result	return 0
	RET	2:result
	END

*========================================================================
* REM_PRINT must be supported entirely by the editor.  Why would we want
* to print a Pascal String?  We don't.
*
* The REM_CLOSE parameter block is used by REM_PRINT too:
*
* fCloseRec
*   word		resType      - rPString
*   long		resID        - 0x00000001 ... 0x07ffffff
*   word		fFlag        - PageSetup request if bit 13 (0x2000) is set
*   Pointer	windowPtr    - editor's GrafPortPtr
*
REM_PRINT START
*
* word REM_PRINT(fCloseRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_PRINT'
go	CSUB	(4:p),2
*
result	EQU	dp	01 word

	STZ	result	return 0
	RET	2:result
	END

*========================================================================
* REM_STARTUP is called only when the REM is first loaded.
*
* The REM should do whatever it needs to do to setup globals, etc.
*
* This is the only time when the various Foundation and REM resource file
* ID's are passed to the REM.  Also, the REM's specific memory manager ID
* is passed here - READ THE WARNING IN REM_SHUTDOWN!
*
REM_STARTUP START
*
* word REM_STARTUP(fStartStopRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_STARTUP'
go	CSUB	(4:p),6
*
result	EQU	dp	01 word

	LDA	[p]	fUserID = p->edUserID;
	STA	fUserID

	LDY	#oStartStop_edResFileID	edResFileID = p->edResFileID;
	LDA	[p],Y
	STA	edResFileID

	LDY	#oStartStop_shResFileID	shResFileID = p->shResFileID;
	LDA	[p],Y
	STA	shResFileID

	LDY	#oStartStop_fdResFileID	fdResFileID = p->fdResFileID;
	LDA	[p],Y
	STA	fdResFileID
*
* stuff a rText ID into the editors header help field
*
	LDA	#1	remHelpID = 1L
	STA	remHelpID
	STZ	remHelpID+$2

	STZ	result	return 0
	RET	2:result
	END

*========================================================================
* REM_SHUTDOWN is called when an editor is unloaded.
*
* WARNING: The REM must release any memory allocated at startup. There is
*    no guarantee that once the editor is released that it will be
*    reloaded.
*
REM_SHUTDOWN START
*
* word REM_SHUTDOWN(fStartStopRecPtr p)
*
	BRL	go
	DC	H'7177'
	DW	'REM_SHUTDOWN'
go	CSUB	(4:p),2
*
result	EQU	dp	01 word
*
* before assuming that this simplicity is all you need, read TBR-1, page 12-23!
*
	LDA	fUserID	DisposeAll(fUserID)
	PHA
	_DisposeAll
	STZ	result	return 0
	RET	2:result
	END

*--------------------------------------
* DrawProc - this is all the editor needs to update its window
*
DrawProc START
*
* void DrawProc(void)
*
	BRL	go
	DC	H'7177'
	DW	'DrawProc'

go	PHB		#pragma databank 1
	PEA	~GLOBALS|-8
	PLB
	PLB

	PHA		DrawControls(GetPort())
	PHA
	_GetPort
	_DrawControls

	PLB		#pragma databank 0
	RTL
	END

*--------------------------------------
* checkData - writes a pstring resource only if it is needed - this is
* used by REM_CLOSE, REM_WRITE and REM_ACTIVATE.
*
checkData START
*
* void checkData(long resID, handle resH, handle txtH)
*
	BRL	go
	DC	H'7177'
	DW	'checkData'
go	CSUB	(4:resID,4:resH,4:txtH),28
*
localPtr2 EQU	dp	01 Pointer
*
i	EQU	dp+4	05 int
changed	EQU	dp+6	07 int
size	EQU	dp+8	09 LongWord
resP	EQU	dp+12	0D Pointer
txtP	EQU	dp+16	11 Pointer
*
localPtr1 EQU	dp+20	15 Pointer
localPtr3 EQU	dp+24	19 Pointer
*
* resID	EQU	dp+31	1C LongWord
* resH	EQU	dp+35	20 Handle
* txtH	EQU	dp+39	24 Pointer
*
	PEI	resH+2	HLock(resH)
	PEI	resH
	_HLock

	LDY	#2	resP = *resH
	LDA	[resH]
	STA	resP
	LDA	[resH],Y
	STA	resP+2

	PEI	txtH+2	HLock(txtH)
	PEI	txtH
	_HLock

	LDY	#2	txtP = *txtH;
	LDA	[txtH]
	STA	txtP
	LDA	[txtH],Y
	STA	txtP+2

	STZ	changed	changed = FALSE

	SHORT	A
	LDA	[resP]	if (resP[0] != txtP[0])
	CMP	[txtP]
	LONG	A
	BEQ	else1

	LDA	#TRUE	changed = TRUE
	STA	changed
	BRA	endif1

else1	LDA	[resP]	for (i = resP[0]; i > 0; i--)
	AND	#$FF
	STA	i
*
forLoop	LDA	i	i > 0
	BEQ	endif1
	BMI	endif1

	CLC		if (resP[i] != txtP[i])
	LDA	i
	ADC	resP
	STA	localPtr2
	LDA	#0
	ADC	resP+2
	STA	localPtr2+2

	CLC
	LDA	localPtr1
	ADC	txtP
	STA	localPtr3
	LDA	localPtr1+2
	ADC	txtP+2
	STA	localPtr3+2

	SHORT	M
	LDA	[localPtr2]
	CMP	[localPtr2]
	LONG	M
	BNE	setTrue

	DEC	i
	BRA	forLoop

setTrue	LDA	#TRUE	changed = TRUE
	STA	changed
	BRA	endif1

endif1	LDA	changed	if (changed)
	BEQ	endif2

	PHA		size = GetHandleSize(txtH)
	PHA
	PEI	txtH+2
	PEI	txtH
	_GetHandleSize
	PLA
	STA	size
	PLA
	STA	size+2

	PEI	resH+2	HUnlock(resH)
	PEI	resH
	_HUnlock

	PEI	size+2	SetHandleSize(size, resH)
	PEI	size
	PEI	resH+2
	PEI	resH
	_SetHandleSize

	PEI	resH+2	HLock(resH)
	PEI	resH
	_HLock

	PEI	txtH+2	HandToHand(txtH, resH, size)
	PEI	txtH
	PEI	resH+2
	PEI	resH
	PEI	size+2
	PEI	size
	_HandToHand

	LDA	#2	RefPB.pCount = 2
	STA	RefPB+oResRef_pCount

	LDA	#rPString	RefPB.resType = rPString
	STA	RefPB+oResRef_resType

	LDA	resID	RefPB.resID = resID
	STA	RefPB+oResRef_resID
	LDA	resID+2
	STA	RefPB+oResRef_resID+2

	_fWriteResource RefPB	fWriteResource(& RefPB)

endif2	PEI	resH+2	HUnlock(resH)
	PEI	resH
	_HUnlock

	PEI	txtH+2	DisposeHandle(txtH)
	PEI	txtH
	_DisposeHandle

	RET
	END

*--------------------------------------
* getPrivate is an example of how a common callback can be optimized to
* clean up the functions that use it.
* PrivPB is global
*
getPrivate START
*
* privateDataHndl getPrivate(GrafPortPtr winP)
*
	BRL	go
	DC	H'7177'
	DW	'getPrivate'
go	CSUB	(4:winP),4
*
result	EQU	dp	privateDataHndl
*
	LDA	#4	PrivPB.pCount = 4
	STA	PrivPB+oPrivateData_pCount

	LDA	winP	(GrafPortPtr)PrivPB.winPtr = winP
	STA	PrivPB+oPrivateData_winPtr
	LDA	winP+2
	STA	PrivPB+oPrivateData_winPtr+2

	_fGetPrivateData PrivPB	fGetPrivateData(& PrivPB)

	LDA	PrivPB+oPrivateData_Data	return (privateDataHndl)PrivPB.Data
	STA	result
	LDA	PrivPB+oPrivateData_Data+2
	STA	result+2

	RET	4:result
	END

*--------------------------------------
*
getTitle START
*
* handle getTitle(word type, long ID)
*
	BRL	go
	DC	H'7177'
	DW	'getTitle'
go	CSUB	(2:type,4:ID),20
*
result	EQU	dp	01 Handle
localPtr	EQU	dp+8	09 Pointer
*
title	EQU	dp+12	0D Handle
size	EQU	dp+16	11 LongWord
*
* type	EQU	dp+23	18 word
* ID	EQU	dp+25	1A long
*
* (handle)title = NewHandle(128L, fUserID, 0x8018, 0L)
*
	PHA
	PHA
	PEA	128|-16
	PEA	128
	LDA	fUserID
	PHA
	PEA	$8018
	PEA	0|-16
	PEA	0
	_NewHandle
	PLA
	STA	title
	PLA
	STA	title+2

	LDA	#3	NamePB.pCount = 3
	STA	NamePB+oResName_pCount

	LDA	#rPString	NamePB.resType = rPString
	STA	NamePB+oResName_resType

	LDA	ID	NamePB.resID = ID
	STA	NamePB+oResName_resID
	LDA	ID+2
	STA	NamePB+oResName_resID+2

	LDY	#2	NamePB.resName = (Pointer)*title
	LDA	[title]
	STA	localPtr
	STA	NamePB+oResName_resName
	LDA	[title],Y
	STA	localPtr+2
	STA	NamePB+oResName_resName+2

	_fGetWindowTitle NamePB	(void)fGetWindowTitle(& NamePB)

	LDA	[localPtr]	size = **title & 0xFFL
	AND	#$FF
	STA	size
	STZ	size+2

	PEI	size+2	SetHandleSize(size, title)
	PEI	size
	PEI	title+2
	PEI	title
	_SetHandleSize

	LDA	title	return (handle)(title | 0x80000000L)
	STA	result
	LDA	title+2
	ORA	#$80000000|-16
	STA	result+2

	RET	4:result
	END

~GLOBALS START
	DC	H'00'
edResFileID ENTRY
	DS	2
fdResFileID ENTRY
	DS	2
shResFileID ENTRY
	DS	2
	END

~ARRAYS	START
PrivPB	ENTRY
	DS	24

Data2PB	ENTRY
	DS	14

NamePB	ENTRY
	DS	12

RefPB	ENTRY
	DS	10

DataPB	ENTRY
	DS	20
	END
